library(dygraphs)
library(xts)
library(dplyr)
library(zoo)
library(padr)
library(ggplot2)

#IMPORT AND FORMAT JBT06 AND JBT14, SUM FLOW BY DAY
getwd()
setwd("O:/Proj-15/WRM/15-309 LCBP Jewett Brook Tile Drain Study/Data/Loading Calcs/FlowLinkEditedFiles/Access")

JBT06Flw <- read.csv(file="JBT06_Aggregate.csv", header=TRUE,stringsAsFactors=FALSE)
JBT06Flw$DT<-as.POSIXct(JBT06Flw$DateTime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")

JBT14Flw <- read.csv(file="JBT14_Aggregate.csv", header=TRUE,stringsAsFactors=FALSE)
JBT14Flw$DT<-as.POSIXct(JBT14Flw$DateTime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")

get_interval(JBT06Flw$DT)
get_interval(JBT14Flw$DT)

JBT06flowdailysum<-JBT06Flw%>%thicken("day")%>%group_by(DT_day)%>%summarize(jbt06sumflow=sum(Volume_L))
JBT14flowdailysum<-JBT14Flw%>%thicken("day")%>%group_by(DT_day)%>%summarize(jbt14sumflow=sum(Volume_L))

jbt14jbt06<-merge(JBT06flowdailysum,JBT14flowdailysum,by="DT_day") 

#Scatter plot, regression, trendlines, residual plots
ggplot(jbt14jbt06, aes(x=jbt14sumflow, y=jbt06sumflow)) + geom_point()
write.csv(jbt14jbt06, "jbt14jbt06_dailylowcompare_rexport.csv")

#IMPORT AND FORMAT JBT06 AND JBT05, SUM FLOW BY DAY
getwd()
setwd("O:/Proj-15/WRM/15-309 LCBP Jewett Brook Tile Drain Study/Data/Loading Calcs/FlowLinkEditedFiles/Access")

JBT06Flw <- read.csv(file="JBT06_Aggregate.csv", header=TRUE,stringsAsFactors=FALSE)
JBT06Flw$DT<-as.POSIXct(JBT06Flw$DateTime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")

JBT05Flw <- read.csv(file="JBT05_Aggregate.csv", header=TRUE,stringsAsFactors=FALSE)
JBT05Flw$DT<-as.POSIXct(JBT05Flw$DateTime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")

get_interval(JBT06Flw$DT)
get_interval(JBT05Flw$DT)
sum(is.na(JBT06Flw$DT))
sum(is.na(JBT05Flw$DT))
sum(is.na(JBT06Flw$Volume_L))
sum(is.na(JBT05Flw$Volume_L))

JBT06flowdailysum<-JBT06Flw%>%thicken("day")%>%group_by(DT_day)%>%summarize(jbt06sumflow=sum(Volume_L))
JBT05flowdailysum<-JBT05Flw%>%thicken("day")%>%group_by(DT_day)%>%summarize(jbt05sumflow=sum(Volume_L))

jbt05jbt06<-merge(JBT06flowdailysum,JBT05flowdailysum,by="DT_day") 

#Scatter plot, regression, trendlines, residual plots
ggplot(jbt05jbt06, aes(x=jbt05sumflow, y=jbt06sumflow)) + geom_point()
write.csv(jbt05jbt06, "jbt05jbt06_dailylowcompare_rexport.csv")

#IMPORT AND FORMAT JBT06 AND JBT01, SUM FLOW BY DAY
getwd()
setwd("O:/Proj-15/WRM/15-309 LCBP Jewett Brook Tile Drain Study/Data/Loading Calcs/FlowLinkEditedFiles/Access")

JBT06Flw <- read.csv(file="JBT06_Aggregate.csv", header=TRUE,stringsAsFactors=FALSE)
JBT06Flw$DT<-as.POSIXct(JBT06Flw$DateTime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")

JBT01Flw <- read.csv(file="JBT01_Aggregate.csv", header=TRUE,stringsAsFactors=FALSE)
JBT01Flw$DT<-as.POSIXct(JBT01Flw$DateTime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")

get_interval(JBT06Flw$DT)
get_interval(JBT01Flw$DT)

JBT06flowdailysum<-JBT06Flw%>%thicken("day")%>%group_by(DT_day)%>%summarize(jbt06sumflow=sum(Volume_L))
JBT01flowdailysum<-JBT01Flw%>%thicken("day")%>%group_by(DT_day)%>%summarize(JBT01sumflow=sum(Volume_L))

JBT01jbt06<-merge(JBT06flowdailysum,JBT01flowdailysum,by="DT_day") 

#Scatter plot, regression, trendlines, residual plots
ggplot(JBT01jbt06, aes(x=JBT01sumflow, y=jbt06sumflow)) + geom_point()
write.csv(JBT01jbt06, "JBT01jbt06_dailylowcompare_rexport.csv")


#IMPORT AND FORMAT JBT06 AND JBT16, SUM FLOW BY DAY
getwd()
setwd("O:/Proj-15/WRM/15-309 LCBP Jewett Brook Tile Drain Study/Data/Loading Calcs/FlowLinkEditedFiles/Access")

JBT06Flw <- read.csv(file="JBT06_Aggregate.csv", header=TRUE,stringsAsFactors=FALSE)
JBT06Flw$DT<-as.POSIXct(JBT06Flw$DateTime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")

JBT16Flw <- read.csv(file="JBT16_Aggregate.csv", header=TRUE,stringsAsFactors=FALSE)
JBT16Flw$DT<-as.POSIXct(JBT16Flw$DateTime, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")

get_interval(JBT06Flw$DT)
get_interval(JBT16Flw$DT)

JBT06flowdailysum<-JBT06Flw%>%thicken("day")%>%group_by(DT_day)%>%summarize(jbt06sumflow=sum(Volume_L))
JBT16flowdailysum<-JBT16Flw%>%thicken("day")%>%group_by(DT_day)%>%summarize(JBT16sumflow=sum(Volume_L))

JBT16jbt06<-merge(JBT06flowdailysum,JBT16flowdailysum,by="DT_day") 

#Scatter plot, regression, trendlines, residual plots
ggplot(JBT16jbt06, aes(x=JBT16sumflow, y=jbt06sumflow)) + geom_point()
write.csv(JBT16jbt06, "JBT16jbt06_dailylowcompare_rexport.csv")

